%PRIORVAL.M
function [py,rflag] = priorval(theta,GLOBALS)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Evaluates prior at theta
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

x       = NaN(length(theta),1);
rflag   = 0;

for ii = 1:length(theta)
    if strcmp(GLOBALS.parmlist{ii,3},'N')
        x(ii)   = normpdf(theta(ii),GLOBALS.parmlist{ii,4},GLOBALS.parmlist{ii,5});
    elseif strcmp(GLOBALS.parmlist{ii,3},'IG')
        if theta(ii) > 0
            a       = (GLOBALS.parmlist{ii,4}^2 + 2*GLOBALS.parmlist{ii,5}^2)/GLOBALS.parmlist{ii,5}^2;
            b       = GLOBALS.parmlist{ii,4}*(GLOBALS.parmlist{ii,4}^2 + GLOBALS.parmlist{ii,5}^2)/GLOBALS.parmlist{ii,5}^2;
            x(ii)   = exp(-b/theta(ii))*(b/theta(ii))^a/theta(ii)/gamma(a);
        else
            x(ii)   = NaN;
            rflag   = 1;
            %disp(['Problem with Parameter ' num2str(ii)])
        end
    elseif strcmp(GLOBALS.parmlist{ii,3},'U')
        if theta(ii) >= GLOBALS.parmlist{ii,4} && theta(ii) <= GLOBALS.parmlist{ii,5}
            x(ii)   = 1/(GLOBALS.parmlist{ii,5}-GLOBALS.parmlist{ii,4});
        else
            x(ii)   = NaN;
            rflag   = 1;
            %disp(['Problem with Parameter ' num2str(ii)])
        end
    elseif strcmp(GLOBALS.parmlist{ii,3},'B')
        if theta(ii) >= 0 && theta(ii) <=1
            [a, b]=betaparametertransform(GLOBALS.parmlist{ii,4},GLOBALS.parmlist{ii,5}^2);
            x(ii)=betapdf(0.99999999999999999999999999999999999999999999999999999999^(-1)*theta(ii)',a,b);
        else
            x(ii)   = NaN;
            rflag   = 1;
            %disp(['Problem with Parameter ' num2str(ii)])
        end
    else
        error(['Unknown Prior, Parameter ' num2str(ii)])
    end
end

py = prod(x);